﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using MvcSample.Services;

namespace MvcSample.Controllers
{
    public class HomeController : Controller
    {
        // Wstrzyknięcie konstruktora.
        //private readonly IDateService _dateService;
        //public HomeController(IDateService dateService)
        //{
        //    _dateService = dateService;
        //}

        
        //public IActionResult Index()
        //{
        //    var today = _dateService.Today;
        //    if (today.Month == 3 && today.Day == 21)
        //        ViewData["Message"] = "Zaczęła się wiosna, ciesz się rabatami!";
        //    return View();
        //}


        // Wstrzyknięcie parametru metody. 
        public IActionResult Index([FromServices] IDateService dateService)
        {
            var today = dateService.Today;
            if (today.Month == 3 && today.Day == 21)
                ViewData["Message"] = "Zaczęła się wiosna, ciesz się rabatami!";
            return View();
        }

        public IActionResult About()
        {
            ViewData["Message"] = "Strona zawierająca opis aplikacji.";

            return View();
        }

        public IActionResult Contact()
        {
            ViewData["Message"] = "Strona z informacjami kontaktowymi.";

            return View();
        }

        public IActionResult Error()
        {
            return View();
        }
    }
}
